/* Copyright (c) 2017 FIRST. All rights reserved.
 * Modified by Nigel Verhoek for use in the Wismon FIRST Tech Challenge curriculum.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted (subject to the limitations in the disclaimer below) provided that
 * the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice, this list
 * of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice, this
 * list of conditions and the following disclaimer in the documentation and/or
 * other materials provided with the distribution.
 *
 * Neither the name of FIRST nor the names of its contributors may be used to endorse or
 * promote products derived from this software without specific prior written permission.
 *
 * NO EXPRESS OR IMPLIED LICENSES TO ANY PARTY'S PATENT RIGHTS ARE GRANTED BY THIS
 * LICENSE. THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.firstinspires.ftc.teamcode;

import com.qualcomm.robotcore.eventloop.opmode.LinearOpMode;
import com.qualcomm.robotcore.eventloop.opmode.TeleOp;
import com.qualcomm.robotcore.hardware.DcMotor;

@TeleOp(name="My FIRST Java OpMode", group="Linear OpMode")
public class MyFIRSTJavaOpMode extends LinearOpMode {

    // Declare OpMode members.
    private DcMotor leftDrive;
    private DcMotor rightDrive;

    @Override
    public void runOpMode() {
        // Initialiseer de motoren. De namen tussen aanhalingstekens moeten overeenkomen met de namen in de robot configuratie.
        leftDrive  = hardwareMap.get(DcMotor.class, "leftDrive");
        rightDrive = hardwareMap.get(DcMotor.class, "rightDrive");

        // Een van de motoren zit ondersteboven gemonteerd. Daarom moet deze omgedraaid worden.
        // !!! LET OP: Als de robot de verkeerde kant op rijdt, dan moeten de woorden REVERSE and FORWARD omgewisseld worden.
        leftDrive.setDirection(DcMotor.Direction.REVERSE);
        rightDrive.setDirection(DcMotor.Direction.FORWARD);

        // Wacht tot het programma start (bestuurder drukt op PLAY)
        waitForStart();

        // Uitvoeren tot het einde van de wedstrijd (bestuurder drukt op STOP)
        while (opModeIsActive()) {

            // Maak variabelen aan voor de rij en draai snelheid.
            // !!! LET OP: gebruiken jullie een PS4 controller? haal dan de "-" weg.
            double drive = -gamepad1.left_stick_y;
            double turn  =  gamepad1.right_stick_x;

            // Maak variabelen aan voor de snelheid voor links en rechts
            // Als we met de klok mee willen draaien moet links naar voren bewegen en rechts naar achteren.
            double leftPower    = drive + turn;
            double rightPower   = drive - turn;

            // Zet de snelheid van de motoren gelijk aan de variabelen die we hierboven hebben gemaakt.
            leftDrive.setPower(leftPower);
            rightDrive.setPower(rightPower);
        }
    }
}
